package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie d'un filtre d'objet
 */
public class SaisieFiltreObjet extends Saisie {

	/**
	 * Libell Filtre 
	 */
	protected JLabel libelleFiltre;
	
	/**
	 * Libell Filtre personnalis
	 */
	protected JLabel libelleFiltrePersonnalise;	
	
	/**
	 * Texte filtre
	 */
	protected JTextField filtreObjet;
	
	/**
	 *  Liste de filtres possibles
	 */
	protected JComboBox listeFiltre = new JComboBox();
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 */
	public SaisieFiltreObjet(FenetrePrincipale fenetre, int typeEcran) {

		super(fenetre,typeEcran);
		libelleFiltre = new JLabel("Veuillez entrer le filtre pour la recherche d'objet :");
		libelleFiltrePersonnalise = new JLabel("Veuillez entrer le filtre personnalis :");
		libelleFiltrePersonnalise.setVisible(false);
		filtreObjet = new JTextField(32);
		filtreObjet.setVisible(false);

		/* Si Personnalis... est selectionn on affiche le texte de filtre personnalis */
		listeFiltre.addActionListener(new ActionListener() {
		      public void actionPerformed(ActionEvent e) {
		    	if(!filtreObjet.isVisible() && listeFiltre.getSelectedItem().toString().equalsIgnoreCase("Personnalis...")) {
		    		libelleFiltrePersonnalise.setVisible(true);
		    		filtreObjet.setVisible(true);
		    		affiche();
		    	} else if(filtreObjet.isVisible()) {
		    		libelleFiltrePersonnalise.setVisible(false);
		    		filtreObjet.setVisible(false);
	    			affiche();
		    	}
		      }
		    });		
		
		// chargement du fichier de properties
		Properties fichierProperties = new Properties();
	    try {
	    	fichierProperties.load(this.getClass().getResourceAsStream("/programmeExemple.properties"));
	    	
		} catch (FileNotFoundException e) {
			// On ne fait rien
		} catch (IOException e) {
			// On ne fait rien
		}
		
		listeFiltre.addItem("Aucun");
		listeFiltre.addItem("Personnalis...");
		
		if(fichierProperties != null) {
			
			String filtres = fichierProperties.getProperty("rechercheObjets.filtres");
			if(filtres != null) {
				String[] filtresTab = filtres.split("\\,");
				for (int i = 0; i < filtresTab.length; i++) {
					listeFiltre.addItem(filtresTab[i]);
				}
			}			
		}
	}

	/**
     * Renvoie le filtre
     * @return Filtre
     */
	public String getFiltre() {
		if(listeFiltre.getSelectedItem().toString().equalsIgnoreCase("Personnalis...") && filtreObjet.getText() != null)
			return filtreObjet.getText();
		else if(!listeFiltre.getSelectedItem().toString().equalsIgnoreCase("Aucun"))
			return listeFiltre.getSelectedItem().toString();
		return null;
	}

	/**
	 * Affiche les champs d'entre
	 * @param fenetre La fentre qui doit contenir l'cran d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleFiltre, EcranUtil.styleLibelleSaisie, 0, 0, 1, 1);
	        g.ajoute(listeFiltre, EcranUtil.styleChampTexteSaisie, 0, 1, 1, 1);
	        g.ajoute(libelleFiltrePersonnalise, EcranUtil.styleLibelleSaisie, 1, 0, 1, 1);
	        g.ajoute(filtreObjet, EcranUtil.styleChampTexteSaisie, 1, 1, 1, 1);
	        // Ligne 1
	        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 2, 0, 1, 2);
	        // Ligne 2
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 3, 0, 1, 2);
	        
    	}
    }
}
